/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class VariantLadderBlock
extends LadderBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private final boolean flammable;
    private BooleanSupplier condition;

    public VariantLadderBlock(String type, QuarkModule module, BlockBehaviour.Properties props, boolean flammable) {
        super(props);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_ladder"));
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
        this.module = module;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.flammable = flammable;
    }

    public VariantLadderBlock(String type, QuarkModule module, boolean flammable) {
        this(type, module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_), flammable);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammable;
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public VariantLadderBlock setCondition(BooleanSupplier condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.condition != null && this.condition.getAsBoolean();
    }
}

